/*	MikMod Web Audio library v0.0.1
	(c) 2021 Carlos Rafael Gimenes das Neves.

	https://github.com/sezero/mikmod
	https://github.com/carlosrafaelgn/mikmod/tree/master/libmikmod/webaudio

	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/
"use strict";var LibMikModMessageId;(function(b){b[b.INIT=1]="INIT";b[b.LOAD_MODULE_BUFFER=2]="LOAD_MODULE_BUFFER";b[b.CHANGE_GENERAL_OPTIONS=3]="CHANGE_GENERAL_OPTIONS";b[b.STOP_MODULE=4]="STOP_MODULE";b[b.PLAYBACK_ERROR=5]="PLAYBACK_ERROR";b[b.PLAYBACK_ENDED=6]="PLAYBACK_ENDED"})(LibMikModMessageId||(LibMikModMessageId={}));
class LibMikMod{static init(b){return LibMikMod.loaded?Promise.resolve():new Promise((d,e)=>{LibMikMod.loading?e(LibMikMod.loadErrorStr="The library was still loading"):LibMikMod.loadErrorStr?e(LibMikMod.loadErrorStr):(LibMikMod.loading=!0,LibMikModCLib({wasmBinary:b}).then(h=>{LibMikMod.cLib=h;(h=h._init())?(LibMikMod.loading=!1,e(LibMikMod.loadErrorStr=LibMikMod.getStrerr(h))):(LibMikMod.loading=!1,LibMikMod.loaded=!0,LibMikMod.loadErrorStr=null,d())},h=>{LibMikMod.loading=!1;e(LibMikMod.loadErrorStr=
(h?h.message||h.toString():null)||"Unknown error while loading the library")}))})}static terminate(){LibMikMod.cLib&&(LibMikMod.cLib._terminate(),LibMikMod.cLib=null,LibMikMod.audioBufferPtr=0,LibMikMod.audioBufferUsedLength=0)}static getVersion(){return LibMikMod.cLib?LibMikMod.cLib._getVersion():0}static loadModule(b,d,e){if(!LibMikMod.cLib)return 3;if(!d)return 2;var h=LibMikMod.cLib._preLoadModule(d.byteLength);if(!h)return 2;h=new Uint8Array(LibMikMod.cLib.HEAP8.buffer,h,d.byteLength);"set"in
d?h.set(d,0):h.set(new Uint8Array(d,0,d.byteLength),0);LibMikMod.audioBufferPtr=0;LibMikMod.audioBufferUsedLength=0;e&&(void 0!==e.reverb&&0<=e.reverb&&15>=e.reverb&&(LibMikMod.lastReverb=e.reverb),void 0!==e.hqMixer&&(LibMikMod.lastHqMixer=e.hqMixer?1:0),void 0!==e.interpolation&&(LibMikMod.lastInterpolation=e.interpolation?1:0),void 0!==e.noiseReduction&&(LibMikMod.lastNoiseReduction=e.noiseReduction?1:0),void 0!==e.wrap&&(LibMikMod.lastWrap=e.wrap?1:0),void 0!==e.loop&&(LibMikMod.lastLoop=e.loop?
1:0),void 0!==e.fadeout&&(LibMikMod.lastFadeout=e.fadeout?1:0));return(b=LibMikMod.cLib._loadModule(b,LibMikMod.lastReverb,LibMikMod.lastHqMixer,LibMikMod.lastInterpolation,LibMikMod.lastNoiseReduction,LibMikMod.lastWrap,LibMikMod.lastLoop,LibMikMod.lastFadeout))||LibMikMod.cLib._getAudioBuffer()?b:2}static changeGeneralOptions(b){b&&(void 0!==b.reverb&&0<=b.reverb&&15>=b.reverb&&(LibMikMod.lastReverb=b.reverb),void 0!==b.interpolation&&(LibMikMod.lastInterpolation=b.interpolation?1:0),void 0!==b.noiseReduction&&
(LibMikMod.lastNoiseReduction=b.noiseReduction?1:0),LibMikMod.cLib&&LibMikMod.cLib._changeGeneralOptions(LibMikMod.lastReverb,LibMikMod.lastInterpolation,LibMikMod.lastNoiseReduction))}static stopModule(){LibMikMod.cLib&&(LibMikMod.cLib._freeModule(),LibMikMod.audioBufferPtr=0,LibMikMod.audioBufferUsedLength=0)}static getString(b){if(LibMikMod.cLib&&b){const e=LibMikMod.cLib.HEAP8;let h=0;for(var d=b;e[d]&&1024>h;d++)h++;if(!h)return"";for(d=Array(h);0<h--;)d[h]=e[b+h];return String.fromCharCode.apply(String,
d)}return null}static getSongName(){return LibMikMod.cLib?LibMikMod.getString(LibMikMod.cLib._getSongName()):null}static getModType(){return LibMikMod.cLib?LibMikMod.getString(LibMikMod.cLib._getModType()):null}static getComment(){return LibMikMod.cLib?LibMikMod.getString(LibMikMod.cLib._getComment()):null}static getErrno(){return LibMikMod.cLib?LibMikMod.cLib._getErrno():0}static getStrerr(b){return LibMikMod.cLib?LibMikMod.getString(LibMikMod.cLib._getStrerr(b)):null}static process(b){if(!LibMikMod.cLib)return!1;
let d=LibMikMod.audioBufferUsedLength;var e=b[0];b=e[0];e=e[1];const h=b.length;let l=LibMikMod.tmpBuffer,n=l?l.length-(d>>2):0,x=!0;a:for(let p=0;p<h;p++,n+=2,d-=8){if(0>=d){for(let y=0;3>y;y++){d=LibMikMod.cLib._update();if(0>d){x=!1;l=null;d=0;break a}if(d){LibMikMod.audioBufferPtr=LibMikMod.cLib._getAudioBuffer();l=new Float32Array(LibMikMod.cLib.HEAP8.buffer,LibMikMod.audioBufferPtr,d>>2);n=0;break}}if(!d){l=null;break a}}b[p]=l[n];e[p]=l[n+1]}LibMikMod.tmpBuffer=l;LibMikMod.audioBufferUsedLength=
d;return x}}LibMikMod.cLib=null;LibMikMod.tmpBuffer=null;LibMikMod.audioBufferPtr=0;LibMikMod.audioBufferUsedLength=0;LibMikMod.lastReverb=0;LibMikMod.lastHqMixer=1;LibMikMod.lastInterpolation=1;LibMikMod.lastNoiseReduction=1;LibMikMod.lastWrap=0;LibMikMod.lastLoop=0;LibMikMod.lastFadeout=1;LibMikMod.loading=!1;LibMikMod.loaded=!1;LibMikMod.loadErrorStr=null;
class LibMikModProcessor extends AudioWorkletProcessor{constructor(){super();this.id=0;this.ended=!1;this.port.onmessage=this.handleMessage.bind(this)}postResponse(b){this.port&&this.port.postMessage(b)}handleMessage(b){if(b=b.data)switch(b.messageId){case LibMikModMessageId.INIT:if(b.id||this.id||LibMikMod.loaded||LibMikMod.loading||LibMikMod.loadErrorStr||!b.buffer)break;LibMikMod.init(b.buffer).then(()=>{this.ended=!0;this.id=-1;this.postResponse({id:LibMikMod.getVersion(),messageId:LibMikModMessageId.INIT})},
()=>{this.ended=!0;this.id=-1;this.postResponse({id:0,messageId:LibMikModMessageId.INIT,errorCode:-1,errorStr:LibMikMod.loadErrorStr})});break;case LibMikModMessageId.LOAD_MODULE_BUFFER:if(!b.id||this.id)break;this.id=b.id;const d=LibMikMod.loadModule(sampleRate,b.buffer,b.options);d?(this.ended=!0,this.id=-1,LibMikMod.stopModule(),this.postResponse({id:b.id,messageId:LibMikModMessageId.LOAD_MODULE_BUFFER,errorCode:d,errorStr:LibMikMod.getStrerr(d)})):this.postResponse({id:this.id,messageId:LibMikModMessageId.LOAD_MODULE_BUFFER,
infoSongName:LibMikMod.getSongName(),infoModType:LibMikMod.getModType(),infoComment:LibMikMod.getComment()});break;case LibMikModMessageId.CHANGE_GENERAL_OPTIONS:if(b.id!==this.id)break;LibMikMod.changeGeneralOptions(b.options);break;case LibMikModMessageId.STOP_MODULE:b.id===this.id&&(this.ended=!0,this.id=-1,LibMikMod.stopModule())}}process(b,d,e){return this.ended?!1:LibMikMod.process(d)?!0:(this.ended||(b=this.id,d=LibMikMod.getErrno(),this.ended=!0,this.id=-1,LibMikMod.stopModule(),d?this.postResponse({id:b,
messageId:LibMikModMessageId.PLAYBACK_ERROR,errorCode:d,errorStr:LibMikMod.getStrerr(d)}):this.postResponse({id:b,messageId:LibMikModMessageId.PLAYBACK_ENDED})),!1)}}registerProcessor("libmikmodprocessor",LibMikModProcessor);
var LibMikModCLib=(()=>{var b="undefined"!==typeof document&&document.currentScript?document.currentScript.src:void 0;return function(d={}){function e(c){return a.locateFile?a.locateFile(c,m):m+c}function h(){var c=z.buffer;a.HEAP8=new Int8Array(c);a.HEAP16=new Int16Array(c);a.HEAP32=new Int32Array(c);a.HEAPU8=E=new Uint8Array(c);a.HEAPU16=new Uint16Array(c);a.HEAPU32=new Uint32Array(c);a.HEAPF32=new Float32Array(c);a.HEAPF64=new Float64Array(c)}function l(c){if(a.onAbort)a.onAbort(c);c="Aborted("+
c+")";t(c);I=!0;c=new WebAssembly.RuntimeError(c+". Build with -sASSERTIONS for more info.");A(c);throw c;}function n(c){try{if(c==u&&v)return new Uint8Array(v);if(F)return F(c);throw"both async and sync fetching of the wasm failed";}catch(f){l(f)}}function x(c){if(!v&&(J||B)){if("function"==typeof fetch&&!c.startsWith("file://"))return fetch(c,{credentials:"same-origin"}).then(f=>{if(!f.ok)throw"failed to load wasm binary file at '"+c+"'";return f.arrayBuffer()}).catch(()=>n(c));if(K)return new Promise((f,
k)=>{K(c,g=>f(new Uint8Array(g)),k)})}return Promise.resolve().then(()=>n(c))}function p(c,f,k){return x(c).then(g=>WebAssembly.instantiate(g,f)).then(g=>g).then(k,g=>{t("failed to asynchronously prepare wasm: "+g);l(g)})}function y(c,f,k,g){return c||"function"!=typeof WebAssembly.instantiateStreaming||f.startsWith("data:application/octet-stream;base64,")||f.startsWith("file://")||"function"!=typeof fetch?p(f,k,g):fetch(f,{credentials:"same-origin"}).then(r=>WebAssembly.instantiateStreaming(r,k).then(g,
function(C){t("wasm streaming compile failed: "+C);t("falling back to ArrayBuffer instantiation");return p(f,k,g)}))}function L(){function c(){if(!D&&(D=!0,a.calledRun=!0,!I)){G(M);N(a);if(a.onRuntimeInitialized)a.onRuntimeInitialized();if(a.postRun)for("function"==typeof a.postRun&&(a.postRun=[a.postRun]);a.postRun.length;)O.unshift(a.postRun.shift());G(O)}}if(!(0<q)){if(a.preRun)for("function"==typeof a.preRun&&(a.preRun=[a.preRun]);a.preRun.length;)P.unshift(a.preRun.shift());G(P);0<q||(a.setStatus?
(a.setStatus("Running..."),setTimeout(function(){setTimeout(function(){a.setStatus("")},1);c()},1)):c())}}var a=d,N,A;a.ready=new Promise((c,f)=>{N=c;A=f});var Q=Object.assign({},a),J="object"==typeof window,B="function"==typeof importScripts,m="",F;if(J||B){B?m=self.location.href:"undefined"!=typeof document&&document.currentScript&&(m=document.currentScript.src);b&&(m=b);m=0!==m.indexOf("blob:")?m.substr(0,m.replace(/[?#].*/,"").lastIndexOf("/")+1):"";B&&(F=c=>{var f=new XMLHttpRequest;f.open("GET",
c,!1);f.responseType="arraybuffer";f.send(null);return new Uint8Array(f.response)});var K=(c,f,k)=>{var g=new XMLHttpRequest;g.open("GET",c,!0);g.responseType="arraybuffer";g.onload=()=>{200==g.status||0==g.status&&g.response?f(g.response):k()};g.onerror=k;g.send(null)}}a.print||console.log.bind(console);var t=a.printErr||console.error.bind(console);Object.assign(a,Q);Q=null;var v;a.wasmBinary&&(v=a.wasmBinary);"object"!=typeof WebAssembly&&l("no native wasm support detected");var z,I=!1,E,P=[],M=
[],O=[],q=0,H=null,w=null;var u="libmikmodclib.wasm";u.startsWith("data:application/octet-stream;base64,")||(u=e(u));var G=c=>{for(;0<c.length;)c.shift()(a)},R={b:(c,f,k)=>E.copyWithin(c,f,f+k),a:c=>{var f=E.length;c>>>=0;if(33554432<c)return!1;for(var k=1;4>=k;k*=2){var g=f*(1+.2/k);g=Math.min(g,c+100663296);var r=Math;g=Math.max(c,g);a:{r=r.min.call(r,33554432,g+(65536-g%65536)%65536)-z.buffer.byteLength+65535>>>16;try{z.grow(r);h();var C=1;break a}catch(S){}C=void 0}if(C)return!0}return!1}};(function(){function c(k,
g){k=k.exports;a.asm=k;z=a.asm.c;h();M.unshift(a.asm.d);q--;a.monitorRunDependencies&&a.monitorRunDependencies(q);0==q&&(null!==H&&(clearInterval(H),H=null),w&&(g=w,w=null,g()));return k}var f={a:R};q++;a.monitorRunDependencies&&a.monitorRunDependencies(q);if(a.instantiateWasm)try{return a.instantiateWasm(f,c)}catch(k){t("Module.instantiateWasm callback failed with error: "+k),A(k)}y(v,u,f,function(k){c(k.instance)}).catch(A);return{}})();a._getAudioBuffer=function(){return(a._getAudioBuffer=a.asm.f).apply(null,
arguments)};a._getAudioBufferMaxLength=function(){return(a._getAudioBufferMaxLength=a.asm.g).apply(null,arguments)};a._getAudioBufferUsedLength=function(){return(a._getAudioBufferUsedLength=a.asm.h).apply(null,arguments)};a._getVersion=function(){return(a._getVersion=a.asm.i).apply(null,arguments)};a._init=function(){return(a._init=a.asm.j).apply(null,arguments)};a._freeModule=function(){return(a._freeModule=a.asm.k).apply(null,arguments)};a._terminate=function(){return(a._terminate=a.asm.l).apply(null,
arguments)};a._preLoadModule=function(){return(a._preLoadModule=a.asm.m).apply(null,arguments)};a._loadModule=function(){return(a._loadModule=a.asm.n).apply(null,arguments)};a._changeGeneralOptions=function(){return(a._changeGeneralOptions=a.asm.o).apply(null,arguments)};a._update=function(){return(a._update=a.asm.p).apply(null,arguments)};a._getErrno=function(){return(a._getErrno=a.asm.q).apply(null,arguments)};a._getStrerr=function(){return(a._getStrerr=a.asm.r).apply(null,arguments)};a._getSongName=
function(){return(a._getSongName=a.asm.s).apply(null,arguments)};a._getModType=function(){return(a._getModType=a.asm.t).apply(null,arguments)};a._getComment=function(){return(a._getComment=a.asm.u).apply(null,arguments)};var D;w=function f(){D||L();D||(w=f)};if(a.preInit)for("function"==typeof a.preInit&&(a.preInit=[a.preInit]);0<a.preInit.length;)a.preInit.pop()();L();return d.ready}})();
"object"===typeof exports&&"object"===typeof module?module.exports=LibMikModCLib:"function"===typeof define&&define.amd?define([],function(){return LibMikModCLib}):"object"===typeof exports&&(exports.LibMikModCLib=LibMikModCLib);
